/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "FindAlgorithmTask.h"

#include <util_text/TextUtils.h>
#include <core_api/DNATranslation.h>

namespace GB2 {

FindAlgorithmTask::FindAlgorithmTask(const FindAlgorithmTaskSettings& s) 
: Task (tr("find_in_sequence_task"), TaskFlag_None), config(s), currentPos(0)
{
    tpm = Progress_Manual;
    complementRun = false;
    currentPos = s.searchRegion.startPos;
    assert(config.strand == FindAlgorithmStrand_Direct || config.complementTT!=NULL);
}

void FindAlgorithmTask::run() {
    FindAlgorithm::find(dynamic_cast<FindAlgorithmResultsListener*>(this),
        config.proteinTT,
        config.complementTT,
        config.strand,
        config.insDelAlg,
        config.sequence.constData(),
        config.sequence.size(),
        config.searchRegion,
        config.pattern.constData(),
        config.pattern.length(),
        config.singleShot,
        config.maxErr,
        stateInfo.cancelFlag,
        stateInfo.progress,
        currentPos);
}

void FindAlgorithmTask::onResult(const FindAlgorithmResult& r) {
    lock.lock();
    newResults.append(r);
    lock.unlock();
}

QList<FindAlgorithmResult> FindAlgorithmTask::popResults() {
    lock.lock();
    QList<FindAlgorithmResult> res = newResults;
    newResults.clear();
    lock.unlock();
    return res;
}

} //namespace



