/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_ORF_ALG_TASK_H_
#define _GB2_ORF_ALG_TASK_H_

#include <core_api/Task.h>
#include <core_api/LRegion.h>

#include "ORFFinder.h"

#include <QtCore/QMutex>

namespace GB2 {

class GB2_COREAPI_EXPORT ORFFindTask : public Task, public ORFFindResultsListener {
    Q_OBJECT
public:
    ORFFindTask(const ORFAlgorithmSettings& s, const QByteArray& seq);

    virtual void run();
    virtual void onResult(const ORFFindResult& r);

    QList<ORFFindResult> popResults();

    const ORFAlgorithmSettings& getSettings() const {return config;}

private:
    ORFAlgorithmSettings config;
    QList<ORFFindResult> newResults;
    QMutex lock;
    QByteArray sequence;
};

} //namespace

#endif
