/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_ANNOTATION_SETTINGS_DIALOG_CONTROLLER_H_
#define _GB2_ANNOTATION_SETTINGS_DIALOG_CONTROLLER_H_

#include <ui/ui_AnnotationSettingsDialog.h>

#include <core_api/core_api.h>
#include <gobjects/AnnotationSettings.h>

#include <QtGui/QDialog>
#include <QtGui/QTreeWidgetItem>

namespace GB2 {

class GB2_COREAPI_EXPORT AnnotationSettingsDialogController: public QDialog, public Ui_AnnotationSettingsDialog {
Q_OBJECT
public:

    AnnotationSettingsDialogController(QWidget* p);

private slots:
    void sl_itemClicked(QTreeWidgetItem * item, int column);
    void sl_okClicked();
    void sl_itemDoubleClicked(QTreeWidgetItem* item, int col);

private:
    void loadModel();
    void storeModel();
};


//////////////////////////////////////////////////////////////////////////
class ASTreeItem : public QTreeWidgetItem {
public:
    ASTreeItem(const AnnotationSettings* as);
    
    void fillModel();
    
    void drawColorCell();

    AnnotationSettings as;
};

}//namespace

#endif
