/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "CreateDocumentFromTextDialogController.h"

#include <core_api/IOAdapter.h>
#include <core_api/AppContext.h>
#include <core_api/Task.h>
#include <core_api/ProjectModel.h>
#include <document_format/FastaFormat.h>
#include <document_format/GenbankPlainTextFormat.h>
#include <util_tasks/SaveDocumentTask.h>
#include <core_api/Log.h>

#include <ioadapter/MemBufAdapter.h>
#include <document_format/DocumentFormatUtils.h>
#include <gobjects/GObjectUtils.h>

#include <qfiledialog.h>
#include <qmessagebox.h>


namespace GB2{

static LogCategory log(ULOG_CAT_USER_INTERFACE);

CreateDocumentFromTextDialogController::CreateDocumentFromTextDialogController(QWidget* p): QDialog(p) {
    setupUi(this);
/*    
    DocumentFormatRegistry *dfr =  AppContext::getDocumentFormatRegistry();
    QList<DocumentFormatId> ids = dfr->getRegisteredFormats();
    foreach(DocumentFormatId id, ids){
        DocumentFormat *format = dfr->getFormatById(id);
        DocumentFormatConstraints c;
        c.mustSupportWrite = true;
        if(format->checkConstraints(c)){
            formatBox->addItem(format->getFormatName(), format->getFormatName());
        }
    }

*/
    formatBox->addItem("FASTA", BaseDocumentFormats::PLAIN_FASTA);
    formatBox->addItem("Genbank", BaseDocumentFormats::PLAIN_GENBANK);

    connect(browseButton, SIGNAL(clicked()), SLOT(sl_browseButtonClicked()));
    connect(formatBox, SIGNAL(currentIndexChanged(int)), this, SLOT(sl_indexChanged(int)));

    sl_indexChanged(0);

    addAnnotationWidget();
}

void CreateDocumentFromTextDialogController::sl_browseButtonClicked(){
    LastOpenDirHelper h;
    QString newPath = QFileDialog::getSaveFileName(this, tr("Select file to save..."), h.dir, filter);
    filepathEdit->setText(newPath);
}

void CreateDocumentFromTextDialogController::accept(){
    QString validationError = w->validate();
    if(!validationError.isEmpty()){
        QMessageBox::critical(this, this->windowTitle(), validationError);
        //log.error(validationError);
        return;
    }
    QFileInfo fi(filepathEdit->text());
    QDir dirToSave(fi.dir());
    if (!dirToSave.exists()){
        QMessageBox::critical(this, this->windowTitle(), tr("Directory to save is not exists"));
        log.error(tr("CreateDocumentFromTextDialogController: directory to save is not exists"));
        return;
    }
    if(filepathEdit->text().isEmpty()){
        QMessageBox::critical(this, this->windowTitle(), tr("Entered save filepath is empty"));
        log.error(tr("CreateDocumentFromTextDialogController: entered save filepath is empty"));
        return;
    }
    if(fi.baseName().isEmpty()){
        QMessageBox::critical(this, this->windowTitle(), tr("Filename to save is empty"));
        log.error(tr("CreateDocumentFromTextDialogController: filename to save is empty"));
        return;
    }
    QList<GObject*> objects;
    const QString seqName("Sequence");
    DNASequence seq = w->getSequence();
    DocumentFormatUtils::addSequenceObject(objects, seqName, seq);
    IOAdapterFactory* iof = AppContext::getIOAdapterRegistry()->getIOAdapterFactoryById(BaseIOAdapters::url2io(filepathEdit->text()));
    QVariant currentId = formatBox->itemData(formatBox->currentIndex());
    DocumentFormat *df = AppContext::getDocumentFormatRegistry()->getFormatById(currentId.toString());
    doc = new Document(df, iof, filepathEdit->text(), objects);
    Project *p = AppContext::getProject();
    doc->setModified(true);
    p->addDocument(doc);
    if(saveImmediatelyBox->isChecked()){
        AppContext::getTaskScheduler()->registerTopLevelTask(new SaveDocumentTask(doc, doc->getIOAdapterFactory(), doc->getURL()));
    }
    this->close();
    QDialog::accept();
}

void CreateDocumentFromTextDialogController::reject(){
    QDialog::reject();
    this->close();
}

void CreateDocumentFromTextDialogController::addAnnotationWidget(){
    w = new SeqPasterWidgetController(this);
    QWidget* caw = w->getWidget();    
    QVBoxLayout* l = new QVBoxLayout();
    l->setMargin(0);
    l->addWidget(caw);
    seqPaster->setLayout(l);
    seqPaster->setMinimumSize(caw->layout()->minimumSize());    
}

void CreateDocumentFromTextDialogController::sl_indexChanged( int index ){
    DocumentFormatId currentId = (formatBox->itemData(index)).toString();
    filter = DialogUtils::prepareDocumentsFileFilter(currentId, false);
}

}//ns
