/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_EDIT_QUALIFIER_DIALOG_H_
#define _GB2_EDIT_QUALIFIER_DIALOG_H_

#include <ui/ui_EditQualifierDialog.h>

#include <core_api/core_api.h>
#include <gobjects/AnnotationTableObject.h>

#include <QtGui/QDialog>

namespace GB2 {

class ProjectTreeController;
class ProjectTreeControllerModeSettings;
class Document;
class GObject;

class GB2_COREAPI_EXPORT EditQualifierDialog: public QDialog, public Ui::EditQualifierDialog {
    Q_OBJECT
public:
    EditQualifierDialog(QWidget* p, const Qualifier& q, bool ro);
    
    virtual void accept();
    
    const Qualifier& getModifiedQualifier() const {return q;}

protected:
    bool eventFilter(QObject *obj, QEvent *e);

private:
    Qualifier q;
    
};



}//namespace
#endif
