/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "GUIUtils.h"

#include <core_api/AppContext.h>
#include <core_api/AppSettings.h>
#include <core_api/Settings.h>
#include <core_api/AppSettingsGUI.h>
#include <core_api/UserApplicationsSettings.h>

#include <QtCore/QFile>
#include <QtCore/QProcess>

#include <QtGui/QPainter>
#include <QtGui/QMessageBox>

#include <QUrl>
#include <QDesktopServices>

namespace GB2 {

QAction* GUIUtils::findAction(const QList<QAction*>& actions, const QString& name) {
    foreach(QAction* a, actions) {
        const QString& aname =  a->objectName();
        if (aname == name) {
            return a;
        }
    }
    return NULL;
}

QAction* GUIUtils::findActionAfter(const QList<QAction*>& actions, const QString& name) {
    bool found = false;
    foreach(QAction* a, actions) {
        if (found) {
            return a;
        }
        const QString& aname =  a->objectName();
        if (aname == name) {
            found = true;
        }
    }
    if (found) {
        return NULL;
    }
    return actions.first();
}


QMenu* GUIUtils::findSubMenu(QMenu* m, const QString& name) {
    QAction* action = findAction(m->actions(), name);
    if (action == NULL) {
        return NULL;
    }
    return action->menu();
}

void GUIUtils::disableEmptySubmenus(QMenu* m) {
    foreach(QAction* action, m->actions()) {
        QMenu* am = action->menu();
        if (am!=NULL && am->actions().isEmpty()) {
            action->setEnabled(false);
        }
    }
}


static QList<QColor> prepareColors() {
    QList<QColor> colors;
    QString mustHave = "FF";
    QStringList optional;
    optional<<"FF"<<"CC"<<"99"<<"66"<<"33"<<"00";
    for(int i = 0; i < 3; i++) { 
        for(int j=0; j < optional.size(); j++) {
            for(int k=1; k < optional.size(); k++) { //todo: avoid duplicates
                QString colorName = 
                    i == 0 ? mustHave + optional[j] + optional[k] : 
                    i == 1 ? optional[j] + mustHave + optional[k] :
                    optional[j] + optional[k] + mustHave;
                QColor c("#"+colorName);
                assert(c.isValid());
                colors.append(c);
            }
        }
    }
    return colors;
}


QColor GUIUtils::genLightColor(const QString& name) {
    static QList<QColor> colors = prepareColors();

    int hash = 0;
    QByteArray a = name.toAscii();
    for (int i=0;i<a.size(); i++) {
        hash+=a[i];
    }
    QColor c = colors.at((hash*hash)%colors.size());
    return c;
}

QIcon  GUIUtils::createSquareIcon(const QColor& c, int size) {
    int w = size;
    int h = size;
    if(AppContext::getSettings()->getValue(GLOBAL_SETTINGS + "drawIcons", true).toBool()){
        QPixmap pix(w, h);
        QPainter p(&pix);
        p.setPen(Qt::black);
        p.drawRect(0, 0, w-1, h-1);
        p.fillRect(1, 1, w-2, h-2, c);
        p.end();
        return QIcon(pix);
    }else{
        return QIcon();
    }
}

QIcon  GUIUtils::createRoundIcon(const QColor& c, int size) {
    int w = size;
    int h = size;

    if(AppContext::getSettings()->getValue(GLOBAL_SETTINGS + "drawIcons", true).toBool()){
        QPixmap pix(w, h);
        pix.fill(Qt::transparent);

        QPainter p(&pix);
        QPainterPath ep;
        //ep.addEllipse(1, 1, w-2, h-2);
        ep.addEllipse(0, 0, w-1, h-1);
        p.fillPath(ep, c);
        p.setPen(Qt::black);
        p.drawEllipse(0, 0, w-1, h-1);
        p.end();
        return QIcon(pix);
    }else{
        return QIcon();
    }
}

bool GUIUtils::runWebBrowser(const QString& url) {
    bool useDefaultWebBrowser = AppContext::getAppSettings()->getUserAppsSettings()->useDefaultWebBrowser();
    if (url.isEmpty()) {
        QMessageBox::critical(NULL, tr("error"), tr("url_is_empty"));
        return false;
    }
    
    QString program = AppContext::getAppSettings()->getUserAppsSettings()->getWebBrowserURL();
    bool ok = !program.isEmpty() && QFile(program).exists();

    if(useDefaultWebBrowser){
        bool launched = QDesktopServices::openUrl(QUrl(url));
        if (!launched){
            QMessageBox::critical(NULL, tr("error"), tr("Unable to launch default web browser."));
            AppContext::getAppSettings()->getUserAppsSettings()->setUseDefaultWebBrowser(false);
            AppContext::getAppSettingsGUI()->showSettingsDialog(APP_SETTINGS_USER_APPS);            
            program = AppContext::getAppSettings()->getUserAppsSettings()->getWebBrowserURL();
            ok = !program.isEmpty() && QFile(program).exists();
            if (!ok) {
                return false;
            }
            QString p = program;
            QStringList arguments;
            arguments.append(url);
            QProcess myProcess;
            return myProcess.startDetached(program, arguments);
        }else {
            return launched;
        }
    }else{
        if (!ok) {
            QMessageBox::critical(NULL, tr("error"), tr("setup_web_browser"));
            AppContext::getAppSettingsGUI()->showSettingsDialog(APP_SETTINGS_USER_APPS);
            program = AppContext::getAppSettings()->getUserAppsSettings()->getWebBrowserURL();

        ok = !program.isEmpty() && QFile(program).exists();
        }
        if (!ok) {
            return false;
        }
        QString p = program;
        QStringList arguments;
        arguments.append(url);
        QProcess myProcess;
        return myProcess.startDetached(program, arguments);
    }
}

} //endif
