/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "ProjectTreeItemSelectorDialog.h"
#include "ProjectTreeController.h"

#include <QtGui/QTreeWidget>
#include <QtGui/QVBoxLayout>
#include <QtGui/QHBoxLayout>
#include <QtGui/QSpacerItem>
#include <QtGui/QPushButton>

namespace GB2 {

ProjectTreeItemSelectorDialog::ProjectTreeItemSelectorDialog(QWidget* p, const ProjectTreeControllerModeSettings& s) 
: QDialog(p)
{
    setupUi(this);
    controller = new ProjectTreeController(this, treeWidget, s);
    connect(controller, SIGNAL(si_doubleClicked(GObject*)), SLOT(sl_objectClicked(GObject*)));
    acceptByDoubleClick = true;
}

void ProjectTreeItemSelectorDialog::sl_objectClicked(GObject* obj) {
    Q_UNUSED(obj);
    if (acceptByDoubleClick) {
        accept();
    }
}

ProjectTreeItemSelectorDialog::~ProjectTreeItemSelectorDialog() {
    delete controller;
}

QList<Document*> ProjectTreeItemSelectorDialog::selectDocuments(const ProjectTreeControllerModeSettings& s, QWidget* p) {
    QList<Document*> res;
    ProjectTreeItemSelectorDialog d(p, s);
    int rc = d.exec();
    if (rc == QDialog::Accepted) {
        const DocumentSelection* ds = d.controller->getDocumentSelection();
        res << ds->getSelectedDocuments();
    }
    return res;    
}

QList<GObject*> ProjectTreeItemSelectorDialog::selectObjects(const ProjectTreeControllerModeSettings& s, QWidget* p) {
    QList<GObject*> res;
    ProjectTreeItemSelectorDialog d(p, s);
    int rc = d.exec();
    if (rc == QDialog::Accepted) {
        const GObjectSelection* os = d.controller->getGObjectSelection();
        res << os->getSelectedObjects();
    }
    return res;
}

}//namespace
