/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_RANGE_SELECTOR_H_
#define _GB2_RANGE_SELECTOR_H_ 

#include <core_api/core_api.h>

#include <QtGui/QLineEdit>
#include <QtGui/QDialog>

namespace GB2 {

class GB2_COREAPI_EXPORT RangeSelector : public QWidget {
	Q_OBJECT
public:
	RangeSelector(QWidget* p, int rangeStart, int rangeEnd);
    RangeSelector(QDialog* d, int rangeStart, int rangeEnd, bool autoclose);

	~RangeSelector();
    int getStart() const;
    int getEnd() const;

signals:
	void si_rangeChanged(int startPos, int endPos);

private slots:
	void sl_onGoButtonClicked(bool);
	void sl_onMinButtonClicked(bool);
	void sl_onMaxButtonClicked(bool);
	void sl_onReturnPressed();

private:
    void init();
	void exec();

	int         rangeStart;
	int         rangeEnd;
    QLineEdit*  startEdit;
	QLineEdit*  endEdit;
    QDialog*    dialog;
    bool        autoclose;
};

}//namespace

#endif
