/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_MSA_EDITOR_H_
#define _GB2_MSA_EDITOR_H_

#include <core_api/ObjectViewModel.h>
#include <core_api/LRegion.h>

#include <QtGui/QScrollBar>
#include <QtGui/QMenu>
#include <QtGui/QSplitter>

namespace GB2 {

class MAlignmentObject;
class MSAEditorUI;
class MSAEditorSequenceArea;
class MSAEditorConsensusArea;
class MSAEditorNameList;
class MSAEditorOffsetsViewController;
class MSAEditorStatusWidget;
class MSAEditorUndoFramework;

#define MSAE_MENU_COPY          "MSAE_MENU_COPY"
#define MSAE_MENU_EDIT          "MSAE_MENU_EDIT"
#define MSAE_MENU_VIEW          "MSAE_MENU_VIEW"
#define MSAE_MENU_ALIGN         "MSAE_MENU_ALIGN"
#define MSAE_MENU_STATISTICS    "MSAE_MENU_STATISTICS"
#define MSAE_MENU_ADVANCED      "MSAE_MENU_ADVANCED"



class GB2_COREAPI_EXPORT MSAEditor : public GObjectView {
    Q_OBJECT
public:
    MSAEditor(const QString& viewName, MAlignmentObject* obj);
    ~MSAEditor();

    virtual void buildStaticToolbar(QToolBar* tb);

    virtual void buildStaticMenu(QMenu* m);

    virtual Task* updateViewTask(const QString& stateName, const QVariantMap& stateData);

    virtual QVariantMap saveState();
    
    MAlignmentObject* getMSAObject() const {return msaObject;}

    const MSAEditorUI* getUI() const {return ui;}

    int getAlignmentLen() const;
    
    int getNumSequences() const;

protected slots:
    void sl_onContextMenuRequested(const QPoint & pos);

protected:
    virtual QWidget* createWidget();

private:
    void addCopyMenu(QMenu* m);
    void addEditMenu(QMenu* m);
    void addViewMenu(QMenu* m);
    void addAlignMenu(QMenu* m);
    void addAdvancedMenu(QMenu* m);
    void addStatisticsMenu(QMenu* m);

    MAlignmentObject* msaObject;
    MSAEditorUI* ui;

};

class MSAEditorUI : public QWidget {
    Q_OBJECT
    //todo: make public accessors:
    friend class MSAEditorSequenceArea;
    friend class MSAEditorConsensusArea;
    friend class MSAEditorNameList;
    friend class MSAEditor;

public:
    MSAEditorUI(MSAEditor* editor);

    void addLine(int row, QWidget* nameAreaWiget, QWidget* sequenceAreaWidget);
    
    QWidget* createLabelWidget(const QString& text = QString(), Qt::Alignment ali = Qt::AlignCenter) const;

    MSAEditorSequenceArea* getSequenceWidget() const {return seqArea;}

    bool eventFilter(QObject* o, QEvent* e);    

    QAction* getUndoAction() const;
    QAction* getRedoAction() const;

private slots:
    void sl_saveScreenshot();

private:
    void updateMSALayout();    

    MSAEditor*                      editor;
    MSAEditorNameList*              nameList;
    MSAEditorSequenceArea*          seqArea;
    MSAEditorConsensusArea*         consArea;
    MSAEditorOffsetsViewController* offsetsView;
    MSAEditorStatusWidget*          statusWidget;
    QSplitter*                      splitter;

    QList<QWidget*>                 nameAreaWidgets;
    QList<QWidget*>                 lw1Widgets;
    QList<QWidget*>                 seqAreaWidgets;
    QList<QWidget*>                 lw2Widgets;
    MSAEditorUndoFramework*         undoFWK;

};



class MSALabelWidget : public QWidget {
    Q_OBJECT
public:
    MSALabelWidget(const MSAEditorUI* _ui, const QString & _t, Qt::Alignment _a);
    
    const MSAEditorUI*  ui;
    QString             text;
    Qt::Alignment       ali;

protected slots:
    void sl_scaleChanged() {update();}

protected:
    void paintEvent(QPaintEvent *e);
};


}//namespace;

#endif
