/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_MSA_EDITOR_OFFSETS_VIEW_H_
#define _GB2_MSA_EDITOR_OFFSETS_VIEW_H_

#include <QtCore/QObject>
#include <QtCore/QVector>
#include <QtCore/QEvent>

#include <QtGui/QWidget>

namespace GB2 {

class MAlignmentObject;
class MAlignment;
class MAlignmentModInfo;
class MSAEditorSequenceArea;
class MSAEditorBaseOffsetCache;
class MSAEditorOffsetsViewWidget;

class MSAEditorOffsetsViewController : public QObject {
    Q_OBJECT
public:
    MSAEditorOffsetsViewController(QObject* p, MAlignmentObject* mobj, MSAEditorSequenceArea* seqArea);

    MSAEditorOffsetsViewWidget* getLeftWidget() const {return lw;}
    MSAEditorOffsetsViewWidget* getRightWidget() const {return rw;}

    QAction* getToggleColumnsViewAction() const {return viewAction;}
    bool eventFilter(QObject* o, QEvent* e);

private slots:
    void sl_alignmentChanged(const MAlignment&, const MAlignmentModInfo&){updateOffsets();}
    void sl_startChanged(const QPoint& , const QPoint& ) {updateOffsets();}
    void sl_scaleChanged() {updateOffsets();}
    void sl_showOffsets(bool);
private:
    void updateOffsets();
    
    MSAEditorSequenceArea*      seqArea;
    MSAEditorOffsetsViewWidget* lw;
    MSAEditorOffsetsViewWidget* rw;
    QAction*                    viewAction;
};

class MSAEditorOffsetsViewWidget : public QWidget {
    friend class MSAEditorOffsetsViewController;
public:
    MSAEditorOffsetsViewWidget(MSAEditorSequenceArea* seqArea, MSAEditorBaseOffsetCache* cache, bool showStartPos);
    ~MSAEditorOffsetsViewWidget();
    
protected:
    void paintEvent(QPaintEvent* e);
    void updateView();
    void drawAll(QPainter& p);
    QFont getOffsetsFont();

private:
    MSAEditorSequenceArea*      seqArea;
    MSAEditorBaseOffsetCache*   cache;
    bool                        showStartPos;
    bool                        completeRedraw;
    QPixmap*                    cachedView;
};

}//namespace;

#endif
