/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_SMITH_WATERMAN_RESULT_FILTERS_H_
#define _GB2_SMITH_WATERMAN_RESULT_FILTERS_H_

#include <QList>
#include <core_api/LRegion.h>
#include <util_smith_waterman/SmithWatermanResult.h>

namespace GB2 {

class GB2_COREAPI_EXPORT SmithWatermanResultFilter {
public:
    virtual bool applyFilter(QList<SmithWatermanResult>* lst) = 0;
    virtual ~SmithWatermanResultFilter() {};
};

class GB2_COREAPI_EXPORT SWRF_EmptyFilter: public SmithWatermanResultFilter {
public:
    virtual bool applyFilter(QList<SmithWatermanResult>* lst);
private:
    bool needErase(const SmithWatermanResult& currItem,
                   const SmithWatermanResult& someItem) const;
};

class GB2_COREAPI_EXPORT SWRF_WithoutIntersect: public SmithWatermanResultFilter {
public:
    virtual bool applyFilter(QList<SmithWatermanResult>* lst);
private:
    bool needErase(const SmithWatermanResult& currItem,
                   const SmithWatermanResult& someItem) const;

};

} // namesapce

#endif
