/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_SMITH_WATERMAN_UTIL_H_
#define _GB2_SMITH_WATERMAN_UTIL_H_

#include <util_smith_waterman/SubstMatrix.h>

namespace GB2 {

class GB2_COREAPI_EXPORT SmithWatermanUtil {
public:
    static float calcScoreItSelf(const SubstMatrix* pSm,
                                 const char* pattern, 
                                 int patternLen);

    static int calcWindowLen(bool transl,
                             int sequenceLen,
                             int patternLen,
                             float scoreItSelf,
							 float thresholdScore,
							 float scoreGapOpen,
							 float scoreGapExtd);

    static float calcScoreThreshold(float percent, 
                                    float scoreItSelf);

    static int calcOverlapSize(bool transl,
                               int windowLen,
                               float scoreItSelf,
                               float scoreGapOpen, 
                               float scoreGapExtd);
private:
    SmithWatermanUtil();
};

} //namespace

#endif
