/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "SubstMatrixFactory.h"
#include <core_api/DNAAlphabet.h>
#include <core_api/AppContext.h>

namespace GB2 {

static const float defScore = -7.0f;

SubstMatrix* SubstMatrixFactory::createSubstMatrix(	
									const QByteArray& mtxAlphabet,
									const float* rawMtx
								) {
	
	DNAAlphabetRegistry* alphRegistry = AppContext::getDNAAlphabetRegistry();
	if (0 == alphRegistry || alphRegistry->getRegisteredAlphabets().isEmpty()) {
		return 0;
	}
	
	DNAAlphabet* similarityAlph = alphRegistry->findAlphabet(mtxAlphabet);
	if (0 == similarityAlph) {
		return 0;
	}
	
	char defSymbol = similarityAlph->getDefaultSymbol();
	int defSymbolIndex = mtxAlphabet.indexOf(defSymbol);

	float defSymbolScore = defScore;
	if (-1 != defSymbolIndex) {
		int rawDim = mtxAlphabet.length();
		defSymbolScore = getMin(&rawMtx[rawDim * defSymbolIndex], rawDim);
	}

	SubstMatrix* pSm = new SubstMatrix();
	if (0 == pSm) {
		return 0;
	}

	if (!pSm->create(similarityAlph, mtxAlphabet, rawMtx, defSymbolScore)) {
		delete pSm;
		return 0;
	}
	return pSm;
}

float SubstMatrixFactory::getMin(const float* src, int len) {
	if (0 == src || len <= 0) {
		return 0.0F;
	}
	float resMin = src[0];
	for (int i = 1; i < len; i++) {
		resMin = qMin(resMin, src[i]);
	}
	return resMin;
}

} // namespace
