/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/


#ifndef _GB2_EXPORT_TO_NEW_FILE_FROM_INDEX_TASK_H_
#define _GB2_EXPORT_TO_NEW_FILE_FROM_INDEX_TASK_H_

#include <core_api/DocumentModel.h>

#include <core_api/Task.h>
#include <datatype/UIndex.h>

namespace GB2 {

class IOAdapter;
class GetDocumentFromIndexTask;
class SaveDocumentStreamingTask;

/*
 * Exported documents may be written to filename not in docNums list order
 */
class GB2_COREAPI_EXPORT ExportToNewFileFromIndexTask : public Task {
    Q_OBJECT
public:
    ExportToNewFileFromIndexTask( const UIndex& index, const QList< int >& docNums, const QString& filename );
    ~ExportToNewFileFromIndexTask();
    
    virtual void prepare();
    virtual ReportResult report();
    
private:
    QList< Task* > getDocTaskFinished( GetDocumentFromIndexTask* t );
    QList< Task* > saveDocTaskFinished( SaveDocumentStreamingTask* t );
    
protected:
    virtual QList< Task* > onSubTaskFinished( Task* subTask );
    IOAdapter* getOpenedIOAdapter(const QString& url);
    
private:
    UIndex             index;
    QList< int >       docNums;
    QString            exportFilename;
    QList< Document* > docsToSave;
    
    IOAdapter*                 io;
    SaveDocumentStreamingTask* saveCurDocTask;
    
}; // ExportToNewFileFromIndexTask

} // GB2

#endif // _GB2_EXPORT_TO_NEW_FILE_FROM_INDEX_TASK_H_
