/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/


#ifndef _GB2_GET_DOCUMENT_FROM_INDEX_TASK_H_
#define _GB2_GET_DOCUMENT_FROM_INDEX_TASK_H_

#include <core_api/Task.h>
#include <datatype/UIndex.h>
#include <core_api/DocumentModel.h>

namespace GB2 {

struct GZipIndexAccessPoint;

class GB2_COREAPI_EXPORT GetDocumentFromIndexTask : public Task {
    Q_OBJECT
public:
    GetDocumentFromIndexTask( const UIndex& index, int docNum );
    ~GetDocumentFromIndexTask();
    
    virtual void run();
    virtual ReportResult report();
    virtual void cleanup();
    
    Document* getDocument() const;
    Document* takeDocument();

private:
    bool fillAccessPointNums( GZipIndexAccessPoint& point, const QString& numStr );
    bool getGzipIndexAccessPoint( GZipIndexAccessPoint& ret, const UIndex::IOSection& ioSec, qint64 offset );
    IOAdapter* getOpenedIOAdapter(const UIndex::ItemSection& itemSec, const UIndex::IOSection& ioSec);
private:
    UIndex    index;
    int       docNum;
    Document* doc;
    
}; // GetDocumentFromIndexTask

} // GB2

#endif // _GB2_GET_DOCUMENT_FROM_INDEX_TASK_H_
