/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_BIOSTRUCT3D_BALLANDSTICK_RENDERER_H_
#define _GB2_BIOSTRUCT3D_BALLANDSTICK_RENDERER_H_

#include "BioStruct3DGLRender.h"

namespace GB2 { 

class BallAndStickGLRenderer : public BioStruct3DGLRenderer {

        
    void drawAtoms(const BioStruct3DColorScheme* s);
    
    void drawBonds(const BioStruct3DColorScheme* s);
    
    unsigned int atomDL;

    QList<int> modelIndexList;

public:
    
	BallAndStickGLRenderer(const BioStruct3D& struc, const BioStruct3DColorScheme* s); 
	
    void drawBioStruct3D();

    RENDERER_FACTORY(BallAndStickGLRenderer)

};

} //namespace

#endif // _GB2_BIOSTRUCT3D_BALLANDSTICK_RENDERER_H_
