/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_BIOSTRUCT3D_VIEW_PLUGIN_H_
#define _GB2_BIOSTRUCT3D_VIEW_PLUGIN_H_

#include <core_api/PluginModel.h>
#include <core_api/AppContext.h>
#include <core_api/ObjectViewModel.h>

#include <QtCore/QMap>
#include <QtGui/QAction>

namespace GB2 {

class BioStruct3DSplitter;
class BioStruct3DObject;

class BioStruct3DViewPlugin : public Plugin {
    Q_OBJECT
public:
    BioStruct3DViewPlugin();
    ~BioStruct3DViewPlugin();
    QAction* loadRemotePDBFileAction;
private slots:
    void sl_downloadRemotePDBFile();
private:
    GObjectViewWindowContext* viewContext;
};

class BioStruct3DViewContext: public GObjectViewWindowContext {
    Q_OBJECT
	QMap<QString, BioStruct3DSplitter*> splitterMap;
public:
    BioStruct3DViewContext(QObject* p);
    
    virtual bool canHandle(GObjectView* v, GObject* o);

    virtual void onObjectAdded(GObjectView* v, GObject* obj);
    virtual void onObjectRemoved(GObjectView* v, GObject* obj);

protected:
    virtual void initViewContext(GObjectView* view);

    BioStruct3DSplitter* get3DView(GObjectView* view, bool create);
    void remove3DView(GObjectView* view);

    QAction* getClose3DViewAction(GObjectView* view);


protected slots:
    void sl_close3DView();

};


} //namespace

#endif
