/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "ORFMarkerPlugin.h"
#include "ORFDialog.h"
#include "ORFWorker.h"


#include <util_algorithm/GAutoDeleteList.h>
#include <util_gui/GUIUtils.h>
#include <util_ov_annotated_dna/AnnotatedDNAView.h>
#include <util_ov_annotated_dna/ADVConstants.h>
#include <util_ov_annotated_dna/ADVSequenceObjectContext.h>
#include <util_ov_annotated_dna/ADVUtils.h>

#include <QtGui/QMenu>
#include <QtCore/QMap>
#include <QtGui/QAction>

#include "ORFMarkerTests.h"

#include <test_framework/xmltest/XMLTestFormat.h>
#include <test_framework/GTest.h>
#include <test_framework/GTestFrameworkComponents.h>

#include <core_api/AppContext.h>



namespace GB2 {

extern "C" Q_DECL_EXPORT Plugin* GB2_PLUGIN_INIT_FUNC() {
    ORFMarkerPlugin* plug = new ORFMarkerPlugin();
    return plug;
}

ORFMarkerPlugin::ORFMarkerPlugin() : Plugin(tr("orfname"), tr("orfdesc")), viewCtx(NULL) {
    if (AppContext::getMainWindow()) {
        viewCtx = new ORFViewContext(this);
        viewCtx->init();
    }

    LocalWorkflow::ORFWorkerFactory::init();

	//ORFMarker test
	GTestFormatRegistry* tfr = AppContext::getTestFramework()->getTestFormatRegistry();
	XMLTestFormat *xmlTestFormat = qobject_cast<XMLTestFormat*>(tfr->findFormat("XML"));
	assert(xmlTestFormat!=NULL);

    GAutoDeleteList<XMLTestFactory>* l = new GAutoDeleteList<XMLTestFactory>(this);
    l->qlist = ORFMarkerTests::createTestFactories();

    foreach(XMLTestFactory* f, l->qlist) { 
		bool res = xmlTestFormat->registerTestFactory(f);
		Q_UNUSED(res);
		assert(res);
	}
}

ORFMarkerPlugin::~ORFMarkerPlugin() {
    //printf("ORF deallocated!\n");
}

ORFViewContext::ORFViewContext(QObject* p) : 
GObjectViewWindowContext(p, ANNOTATED_DNA_VIEW_FACTORY_ID) {}

void ORFViewContext::initViewContext(GObjectView* v) {
    AnnotatedDNAView* av = qobject_cast<AnnotatedDNAView*>(v);
    ADVGlobalAction* a = new ADVGlobalAction(av, QIcon(":orf_marker/images/orf_marker.png"), tr("Find ORFs"), 20);
    a->addAlphabetFilter(DNAAlphabet_NUCL);
    connect(a, SIGNAL(triggered()), SLOT(sl_showDialog()));
}

void ORFViewContext::sl_showDialog() {
    QAction* a = (QAction*)sender();
    GObjectViewAction* viewAction = qobject_cast<GObjectViewAction*>(a);
    AnnotatedDNAView* av = qobject_cast<AnnotatedDNAView*>(viewAction->getObjectView());
    assert(av);

    ADVSequenceObjectContext* seqCtx = av->getSequenceInFocus();
    assert(seqCtx->getAlphabet()->isNucleic());
    ORFDialog d(seqCtx);
    d.exec();
}

QList<XMLTestFactory*> ORFMarkerTests::createTestFactories() {
	QList<XMLTestFactory*> res;
	res.append(GTest_ORFMarkerTask::createFactory());
	return res;
}


}//namespace

