/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_REMOTE_REQUEST_TASK_H_
#define _GB2_REMOTE_REQUEST_TASK_H_

#include <core_api/Task.h>
#include <datatype/AnnotationData.h>

#include "RemoteRequestPlugin.h"

#define ULOG_CAT_PLUGIN_REMOTE_REQUEST "Plugin: Remote request"

namespace GB2 {

class DNATranslation;
class AnnotationTableObject;

class RemoteRequestTask : public Task {
    Q_OBJECT
public:
    RemoteRequestTask( Script * script, int maxrl, int minrl, SendSelectionStrand strand, DNATranslation * complT, 
        DNATranslation * aminoT, const QByteArray & query, int qoffs, AnnotationTableObject* ao, const QString & group );
    
    QList<Task*> onSubTaskFinished(Task* subTask);

    void _run();

private:
    struct Query {
        Query() : complement(false), amino(false), offs(0){}
        QByteArray seq;
        bool complement;     //seq is complemented
        bool amino;     //seq is translated
        int offs;       //translation frame offset
    };
    void  prepareQueries();
    void  prepareEngine();
    void  createAnnotations(const Query & q);

    Script*             script;
    QScriptEngine*      engine;
    int                 maxrl;
    int                 minrl;
    SendSelectionStrand strand;
    DNATranslation*     complT;
    DNATranslation*     aminoT;
    QByteArray          query;
    int                 offsInGlobalSeq;
    QPointer<AnnotationTableObject>  aobj;
    QString             group;
    QList<Query>        queries;
    Task*               queryTask;
    QList<SharedAnnotationData> resultAnnotations;
};

class RemoteRequestSubtask : public Task {
    Q_OBJECT
public:
    RemoteRequestSubtask(RemoteRequestTask* t);
    virtual void run() {t->_run();}
    RemoteRequestTask* t;
};

} //namespace

#endif 
