/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_WORKFLOW_ITEM_STYLE_H_
#define _GB2_WORKFLOW_ITEM_STYLE_H_

#include <QtGui/QGraphicsScene>
#include <QtGui/QGraphicsItem>
#include <QtGui/QTextDocument>
#include <QtGui/QAction>

class QDomElement;

namespace GB2 {

    class WorkflowProcessItem;

    const qreal PI = 3.141596;
    const qreal R = 30;
    const qreal A = 8;


    class ItemViewStyle : public QObject, public QGraphicsItem {
        Q_OBJECT
    public:
        ItemViewStyle(const QString& id);
        QString getId() const {return id;}

        virtual void refresh() {}
        virtual void setActive(bool v) {active = v;}
        bool isActive() const {return active;}
        virtual bool sceneEventFilter(QGraphicsItem *, QEvent *) {return false;}
        virtual QList<QAction*> getContextMenuActions() const {return (QList<QAction*>() << bgColorAction << fontAction);}
        virtual void saveState(QDomElement& ) const;
        virtual void loadState(QDomElement& );
        virtual QColor defaultColor() const = 0;

    protected:
        WorkflowProcessItem* owner;
        bool active;
        QColor bgColor;
        QFont defFont;

        QAction* bgColorAction;
        QAction* fontAction;
        QString id;

    private slots:
        void selectBGColor();
        void selectFont();
    };

    class SimpleProcStyle : public ItemViewStyle {
    public:
        SimpleProcStyle(WorkflowProcessItem* pit);
        QRectF boundingRect(void) const;
        QPainterPath shape() const;
        QColor defaultColor() const;
        void paint(QPainter* painter, const QStyleOptionGraphicsItem* option, QWidget* widget = 0);
    };

    class ExtendedProcStyle : public ItemViewStyle {
        Q_OBJECT
    public:
        ExtendedProcStyle(WorkflowProcessItem* pit);
        QRectF boundingRect(void) const {return bounds;}
        QPainterPath shape () const;
        QColor defaultColor() const;
        void paint ( QPainter * painter, const QStyleOptionGraphicsItem * option, QWidget * widget = 0 );
        virtual void refresh();
        virtual void setActive(bool v);
        virtual bool sceneEventFilter(QGraphicsItem * watched, QEvent * event);
        virtual QList<QAction*> getContextMenuActions() const;
        virtual void saveState(QDomElement& ) const;
        virtual void loadState(QDomElement& );
    private slots:
        void setAutoResizeEnabled(bool b);
    private:
        void setFixedBounds(const QRectF& b);
        QTextDocument* doc;
        QRectF bounds;
        bool autoResize;

        enum ResizeMode {NoResize = 0, HResize = 1, VResize = 2, Resize = HResize + VResize};
        int resizing;
        
        QAction* resizeModeAction;
    };

    class HintItem : public QGraphicsTextItem {
    public:
        HintItem(const QString & text, QGraphicsItem * parent);
    protected:
        virtual QVariant itemChange ( GraphicsItemChange change, const QVariant & value );
    };

}//namespace

#endif
