/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/


#ifndef _GB2_UHMMER_BUILD_TESTS_H_
#define _GB2_UHMMER_BUILD_TESTS_H_

#include <test_framework/xmltest/XMLTestUtils.h>
#include <QtXml/QDomElement>
#include <core_api/Task.h>

#include <build/uHMM3BuildTask.h>

namespace GB2 {

/*****************************************
* Builds hmm profile from input file
*****************************************/
class GTest_UHMMER3Build : public GTest {
    Q_OBJECT
public:
    static const QString INPUT_FILE_TAG;
    static const QString OUTPUT_FILE_TAG;
    static const QString DEL_OUTPUT_TAG;

    static const QString RELATIVE_WEIGHTING_OPTION_TAG; /* --wgsc, --wblosum, --wpb, --wnone, --wgiven */

    static const QString EFFECTIVE_WEIGHTING_OPTION_TAG;/* --eent, --eclust, --enone, --eset */

    static const QString E_VALUE_CALIBATION_OPTION_TAG; /*  */

    static const QString MODEL_CONSTRUCTION_OPTION_TAG; /* --fast + symfrac and 
                                                        --hand ( requires RF annotation )*/
    static const QString SEED_OPTION_TAG;
    
    static void setBuildSettings( UHMM3BuildSettings & settings, const QDomElement& el, TaskStateInfo & ti );
    
public:    
    SIMPLE_XML_TEST_BODY_WITH_FACTORY( GTest_UHMMER3Build, "uhmmer3-build" );
    virtual void prepare();
    ReportResult report();
    void cleanup();

private:
    void setAndCheckArgs();
    
private:
    QString                 inFile;
    QString                 outFile;
    bool                    delOutFile;
    UHMM3BuildToFileTask*   buildTask;
    UHMM3BuildTaskSettings  bldSettings;

}; // GTest_UHMMER3Build

/*****************************************
* Totally compares two hmm files
*****************************************/
class GTest_CompareHmmFiles : public GTest {
    Q_OBJECT
public:
    static const QString FILE1_NAME_TAG;
    static const QString FILE2_NAME_TAG;
    static const QString FILE1_TMP_TAG;
    static const QString FILE2_TMP_TAG;

public:
    SIMPLE_XML_TEST_BODY_WITH_FACTORY( GTest_CompareHmmFiles, "hmm3-compare-files" );
    ReportResult report();

private:
    void setAndCheckArgs();

private:
    QString filename1;
    QString filename2;
    bool    file1Tmp;
    bool    file2Tmp;

}; // GTest_CompareHmmFiles

} // GB2

#endif // _GB2_UHMMER_BUILD_TESTS_H_
