/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/


#ifndef _GB2_UHMMER3_SEARCH_TESTS_H_
#define _GB2_UHMMER3_SEARCH_TESTS_H_

#include <test_framework/xmltest/XMLTestUtils.h>
#include <QtXml/QDomElement>

#include <search/uHMM3SearhTask.h>

namespace GB2 {

/*****************************************
* Test for hmmer3 search.
* 
* we test here only files with one sequences. no multi-queries
*****************************************/
enum GTest_UHMM3SearchAlgoType {
    UNKNOWN_SEARCH = -1,
    GENERAL_SEARCH,
    SEQUENCE_WALKER_SEARCH
};// GTest_UHMM3SearchAlType

class GTest_UHMM3Search : public GTest {
    Q_OBJECT
public:
    static const QString SEQ_DOC_CTX_NAME_TAG; /* loaded sequence document */
    static const QString HMM_FILENAME_TAG;
    static const QString HMMSEARCH_TASK_CTX_NAME_TAG; /* finished UHMM3SearchTask */
    static const QString ALGORITHM_TYPE_OPTION_TAG;
    /* reporting tresholds options */
    static const QString SEQ_E_OPTION_TAG; /* -E */
    static const QString SEQ_T_OPTION_TAG; /* -T */
    static const QString Z_OPTION_TAG; /* -Z */
    static const QString DOM_E_OPTION_TAG; /* --domE */
    static const QString DOM_T_OPTION_TAG; /* --domT */
    static const QString DOM_Z_OPTION_TAG; /* --domZ */
    static const QString USE_BIT_CUTOFFS_OPTION_TAG; /* --cut_ga, --cut_nc, --cut_tc or none */
    /* significance tresholds options */
    static const QString INC_SEQ_E_OPTION_TAG; /* --incE */
    static const QString INC_SEQ_T_OPTION_TAG; /* --incT */
    static const QString INC_DOM_E_OPTION_TAG; /* --incdomE */
    static const QString INC_DOM_T_OPTION_TAG; /* --incdomT */
    static const QString INC_USE_BIT_CUTOFFS_OPTION_TAG; /* --inc_ga, --inc_nc, --inc_tc or none */
    /* acceleration heuristics options */
    static const QString MAX_OPTION_TAG; /* --max */
    static const QString F1_OPTION_TAG; /* --F1 */
    static const QString F2_OPTION_TAG; /* --F2 */
    static const QString F3_OPTION_TAG; /* --F3 */
    static const QString NOBIAS_OPTION_TAG; /* --nobias */
    static const QString NONULL2_OPTION_TAG; /* --nonull2 */
    static const QString SEED_OPTION_TAG; /* --seed */
    
    static void setSearchTaskSettings( UHMM3SearchSettings& set, const QDomElement& el, TaskStateInfo& si );
    
public:
    SIMPLE_XML_TEST_BODY_WITH_FACTORY( GTest_UHMM3Search, "hmm3-search" );
    void prepare();
    ReportResult report();
    void cleanup();

private:
    void setAndCheckArgs();

private:
    UHMM3SearchTaskSettings settings;
    QString                 hmmFilename;
    UHMM3SearchTask*        generalSearchTask;
    UHMM3SWSearchTask*      swSearchTask;
    Task*                   searchTaskToCtx; /* general or sw. we will add it to context */
    QString                 searchTaskCtxName;
    DNASequence             sequence;
    QString                 seqDocCtxName;
    GTest_UHMM3SearchAlgoType algo;

}; // GTest_GeneralUHMM3Search

/*****************************************
* Test compares original hmmer3 search results with UHMM3SearchResults
* 
* Note, that you should make original hmmer3 to show results in academic version (e.g. 1.01e-23)
*****************************************/
class GTest_UHMM3SearchCompare : public GTest {
    Q_OBJECT
public:
    static const QString SEARCH_TASK_CTX_NAME_TAG;
    static const QString TRUE_OUT_FILE_TAG; /* file with original hmmer3 output */
    
    static UHMM3SearchResult getOriginalSearchResult( const QString & filename );
    static void generalCompareResults( const UHMM3SearchResult& myRes, const UHMM3SearchResult& trueRes, TaskStateInfo& ti );
    static void swCompareResults( const UHMM3SWSearchTaskResult& myR, const UHMM3SearchResult& trueR, TaskStateInfo& ti );
    
public:
    SIMPLE_XML_TEST_BODY_WITH_FACTORY( GTest_UHMM3SearchCompare, "hmm3-search-compare" );
    ReportResult report();

private:
    void setAndCheckArgs();

private:
    QString                     searchTaskCtxName;
    QString                     trueOutFilename;
    UHMM3SearchTask*            generalTask;
    UHMM3SWSearchTask*          swTask;
    GTest_UHMM3SearchAlgoType   algo;

}; // GTest_GeneralUHMM3SearchCompare

}

#endif // _GB2_UHMMER3_SEARCH_TESTS_H_
