/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "Primer3Plugin.h"
#include "Primer3DialogController.h"

#include <util_algorithm/GAutoDeleteList.h>
#include <util_gui/GUIUtils.h>

#include <util_ov_annotated_dna/AnnotatedDNAView.h>
#include <util_ov_annotated_dna/ADVConstants.h>
#include <util_ov_annotated_dna/ADVSequenceObjectContext.h>
#include <util_ov_annotated_dna/ADVUtils.h>

#include <gobjects/AnnotationTableObject.h>

#include <QtGui/QMenu>
#include <QtCore/QMap>
#include <QtGui/QAction>
#include <QtGui/QMessageBox>

#include <core_api/AppContext.h>

#include <test_framework/xmltest/XMLTestFormat.h>
#include <test_framework/GTest.h>
#include <test_framework/GTestFrameworkComponents.h>

namespace GB2 {


extern "C" Q_DECL_EXPORT Plugin* GB2_PLUGIN_INIT_FUNC() {
    Primer3Plugin * plug = new Primer3Plugin();
	return plug;
}

Primer3Plugin::Primer3Plugin() : Plugin(tr("primer 3"), tr("primer 3 description")), viewCtx(NULL)
{
    //if (AppContext::getMainWindow()) {
    //    ctxADV = new Primer3ADVContext(this);
    //    ctxADV->init();

    //    QAction* buildAction = new QAction(tr("primer3"), this);
    //    connect(buildAction, SIGNAL(triggered()), SLOT(sl_make_base()));


    //    MWMenuManager* menu = AppContext::getMainWindow()->getMenuManager();
    //    QMenu* tools = menu->getTopLevelMenu(MWMENU_TOOLS);
    //    QMenu* toolsSubmenu = tools->addMenu(QIcon(":/sitecon/images/sitecon.png"), tr("primer3_menu"));

    //    toolsSubmenu->addAction(buildAction);
    //}
    if (AppContext::getMainWindow()) {
        viewCtx = new Primer3ADVContext(this);
        viewCtx->init();
    }

    //////////////////////////////////////////////////////////////////////////
    //tests
    GTestFormatRegistry* tfr = AppContext::getTestFramework()->getTestFormatRegistry();
    XMLTestFormat *xmlTestFormat = qobject_cast<XMLTestFormat*>(tfr->findFormat("XML"));
    assert(xmlTestFormat!=NULL);

    GAutoDeleteList<XMLTestFactory>* l = new GAutoDeleteList<XMLTestFactory>(this);
    l->qlist = Primer3Tests::createTestFactories();


    foreach(XMLTestFactory* f, l->qlist) { 
        bool res = xmlTestFormat->registerTestFactory(f);
        Q_UNUSED(res);
        assert(res);
    }
     
     
}

Primer3Plugin::~Primer3Plugin() {
}

//void Primer3Plugin::sl_make_base() {
//    Primer3DialogController d(this);
//    d.exec();
//}


Primer3ADVContext::Primer3ADVContext(QObject* p) : GObjectViewWindowContext(p, ANNOTATED_DNA_VIEW_FACTORY_ID)
{

}

//void Primer3ADVContext::initViewContext(GObjectView* view) {
//    AnnotatedDNAView* av = qobject_cast<AnnotatedDNAView*>(view);
//    ADVSequenceObjectContext* seqCtx = av->getSequenceInFocus();
//}
//
//void Primer3ADVContext::makeBaseMenu(GObjectView* v, QMenu* m) {
//    QList<GObjectViewAction*> list = getViewActions(v);
//    if (list.isEmpty()) { 
//        return;
//    }
//    assert(list.size()==1);
//    GObjectViewAction* a = list.first();  
//    QMenu* aMenu = GUIUtils::findSubMenu(m, ADV_MENU_ANALYSE);
//    assert(aMenu!=NULL);
//    aMenu->addAction(a);
//}

void Primer3ADVContext::initViewContext(GObjectView* v) {
    AnnotatedDNAView* av = qobject_cast<AnnotatedDNAView*>(v);
    ADVGlobalAction* a = new ADVGlobalAction(av, QIcon(":/primer3/images/primer3.png"), tr("Primer 3"), 95);
    a->addAlphabetFilter(DNAAlphabet_NUCL);
    connect(a, SIGNAL(triggered()), SLOT(sl_showDialog()));
}

void Primer3ADVContext::sl_showDialog() {
    QAction* a = (QAction*)sender();
    GObjectViewAction* viewAction = qobject_cast<GObjectViewAction*>(a);
    AnnotatedDNAView* av = qobject_cast<AnnotatedDNAView*>(viewAction->getObjectView());
    assert(av);

    ADVSequenceObjectContext* seqCtx = av->getSequenceInFocus();
    assert(seqCtx->getAlphabet()->isNucleic());
    Primer3DialogController d(seqCtx);
    d.exec();
}

QList<XMLTestFactory*> Primer3Tests::createTestFactories() {
    QList<XMLTestFactory*> res;
    res.append(GTest_Primer3::createFactory());
    return res;
}

}//namespace