/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_PRIMER3_TESTS_H_
#define _GB2_PRIMER3_TESTS_H_

#include "Primer3DialogController.h"
#include <core_api/core_api.h>
#include <test_framework/xmltest/XMLTestUtils.h>
#include <test_framework/xmltest/XMLTestUtils.h>
#include <core_api/GObject.h>
#include <QtXml/QDomElement>

namespace GB2 {

class GTest_Primer3 : GTest {
Q_OBJECT
public:
    SIMPLE_XML_TEST_BODY_WITH_FACTORY_EXT(GTest_Primer3, "plugin_primer_3", TaskFlags_FOSCOE);

    ~GTest_Primer3();

    void prepare();
    void run();
    void cleanup();
    Task::ReportResult report();
    static char * stringToChar(QString in);

private:
    bool compareDoubles(double referenceNumber, double checkedNumber);
    Primer3Task *t;    
    primer_args *pa;
    seq_args *sa;
    primers_t primers;
    pair_array_t best_pairs;
    pair_array_t currentBestPairs;
    pair_array_t expectedBestPairs;
};

}//ns
#endif