/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_SITECON_SEARCH_DIALOG_H_
#define _GB2_SITECON_SEARCH_DIALOG_H_

#include <core_api/core_api.h>
#include <core_api/LRegion.h>

#include <ui/ui_SiteconSearchDialog.h>

#include <QtCore/QList>
#include <QtGui/QTreeWidgetItem>
#include <QtGui/QCloseEvent>
#include <QtCore/QTimer>

namespace GB2 {

class ADVSequenceObjectContext;
class DNASequenceObject;
class SiteconSearchTask;
class Task;
class SiteconResultItem;
class DiProperty;
class SiteconModel;

class SiteconSearchDialogController : public QDialog, public Ui_SiteconSearchDialog {
    Q_OBJECT
public:
    SiteconSearchDialogController(ADVSequenceObjectContext* ctx);
    ~SiteconSearchDialogController();

public slots:
    virtual void reject();

protected:
    bool eventFilter(QObject *obj, QEvent *ev);

private slots:
    
    //buttons:
    void sl_selectModelFile();
    void sl_onSaveAnnotations();
    void sl_onClearList();
    void sl_onSearch();
    void sl_onClose();

    // groups
    void sl_onTaskFinished();
    void sl_onTimer();

    void sl_onResultActivated(QTreeWidgetItem* i, int col);
    
private:
    void connectGUI();
    void updateState();
    void updateStatus();
    void updateModel(const SiteconModel& m);
    
    bool checkPrevSettings();
    void savePrevSettings();

    void runTask();

    void importResults();

private:
    ADVSequenceObjectContext*   ctx;
    LRegion                     initialSelection;
    
    SiteconModel*       model;

    SiteconSearchTask* task;
    QTimer* timer;
};

}//namespace

#endif
