/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef EdgeList_h
#define EdgeList_h

class EdgeList
	{
public:
	EdgeList();
	virtual ~EdgeList();

public:
	void Clear();
	void Add(unsigned uNode1, unsigned uNode2);
	unsigned GetCount() const;
	void GetEdge(unsigned uIndex, unsigned *ptruNode1, unsigned *ptruNode2) const;
	void Copy(const EdgeList &rhs);
	void LogMe() const;

private:
	void Expand();

private:
	unsigned m_uCount;
	unsigned m_uCacheSize;
	unsigned *m_uNode1;
	unsigned *m_uNode2;
	};

#endif	// EdgeList_h
