/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_NETWORK_SETTINGS_WIDGET_IMPL_H_
#define _GB2_NETWORK_SETTINGS_WIDGET_IMPL_H_

#include <ui/ui_NetworkSettingsWidget.h>

#include <core_api/NetworkConfiguration.h>
#include <core_api/AppSettingsGUI.h>

#include <QtCore/QUrl>

namespace GB2 {


class NetworkSettingsPageController : public AppSettingsGUIPageController {
    Q_OBJECT
public:
    NetworkSettingsPageController(QObject* p = NULL);

    virtual AppSettingsGUIPageState* getSavedState();

    virtual void saveState(AppSettingsGUIPageState* s);

    virtual AppSettingsGUIPageWidget* createWidget(AppSettingsGUIPageState* data);
};


class NetworkSettingsPageState : public AppSettingsGUIPageState {
    Q_OBJECT
public:
    NetworkSettingsPageState();
    NetworkConfiguration config;
};


class NetworkSettingsPageWidget: public AppSettingsGUIPageWidget, public Ui_NetworkSettingsWidget {
    Q_OBJECT
public:
    NetworkSettingsPageWidget();

    virtual void setState(AppSettingsGUIPageState* state);

    virtual AppSettingsGUIPageState* getState(QString& err) const;

private slots:
    void sl_HttpChecked( int state );
    void sl_ExceptionsChecked( int state );
};

}//namespace

#endif
