/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/


#include <core_api/AppContext.h>
#include <cmdline/CMDLineRegistry.h>
#include <cmdline/CMDLineHelpProvider.h>

#include "CMDLineCoreOptions.h"

namespace GB2 {

const QString CMDLineCoreOptions::LOAD_SETTINGS_FILE        = "settings-load-file";
const QString CMDLineCoreOptions::SUITE_URLS                = "test-suite";
const QString CMDLineCoreOptions::TEST_REPORT				= "test-report";
const QString CMDLineCoreOptions::TEST_THREADS				= "test-threads";
const QString CMDLineCoreOptions::LOCAL_TASK_FILES          = "local-task-run";
const QString CMDLineCoreOptions::STAY_ALIVE                = "ugene-stay-alive";
const QString CMDLineCoreOptions::HELP                      = "help";

void CMDLineCoreOptions::initHelp() {
    CMDLineRegistry * cmdLineRegistry = AppContext::getCMDLineRegistry();
    assert( NULL != cmdLineRegistry );
    
    CMDLineHelpProvider * helpSection = new CMDLineHelpProvider( HELP, tr( "show help information" ) );
    
    CMDLineHelpProvider * stayAliveSection = new CMDLineHelpProvider( STAY_ALIVE,
        tr( "ugene will continue executing after finishing given tasks" ) );
    
    CMDLineHelpProvider * taskFilesSectionArguments = new CMDLineHelpProvider( LOCAL_TASK_FILES, "<local-task-to-run> [<task2> ...]" );
    CMDLineHelpProvider * taskFilesSection = new CMDLineHelpProvider( LOCAL_TASK_FILES,
        tr( "read files with serialized tasks and run them" ) );
    
    CMDLineHelpProvider * suiteUrlSectionArguments = new CMDLineHelpProvider( SUITE_URLS, "<test-suite> [suite2 ...]" );
    CMDLineHelpProvider * suiteUrlSection = new CMDLineHelpProvider( SUITE_URLS, tr( "load test suites and run them" ) );

    CMDLineHelpProvider *testReportArgument = new CMDLineHelpProvider( TEST_REPORT,"<test-report-directory>");
    CMDLineHelpProvider *testReport = new CMDLineHelpProvider(TEST_REPORT, tr("set directory for test report"));

    CMDLineHelpProvider *testRunnerThreadsArgument = new CMDLineHelpProvider(TEST_THREADS, "<number-of-threads>");
    CMDLineHelpProvider *testRunnerThreads = new CMDLineHelpProvider(TEST_THREADS,
        tr("set number of threads in test runner that can run at the same time"));
    
    CMDLineHelpProvider * loadSettingsFileSectionArguments = new CMDLineHelpProvider( LOAD_SETTINGS_FILE, "<settings-file>" );
    CMDLineHelpProvider * loadSettingsFileSection = new CMDLineHelpProvider( LOAD_SETTINGS_FILE, tr( "get settings from settings file" ) );
       
    cmdLineRegistry->registerCMDLineHelpProvider( helpSection );
    cmdLineRegistry->registerCMDLineHelpProvider( stayAliveSection );
    cmdLineRegistry->registerCMDLineHelpProvider( taskFilesSectionArguments );
    cmdLineRegistry->registerCMDLineHelpProvider( taskFilesSection );
    cmdLineRegistry->registerCMDLineHelpProvider( suiteUrlSectionArguments );
    cmdLineRegistry->registerCMDLineHelpProvider( suiteUrlSection );
    cmdLineRegistry->registerCMDLineHelpProvider( loadSettingsFileSectionArguments );
    cmdLineRegistry->registerCMDLineHelpProvider( loadSettingsFileSection );
    cmdLineRegistry->registerCMDLineHelpProvider( testReportArgument );
    cmdLineRegistry->registerCMDLineHelpProvider( testReport );
    cmdLineRegistry->registerCMDLineHelpProvider( testRunnerThreadsArgument );
    cmdLineRegistry->registerCMDLineHelpProvider( testRunnerThreads );
}

} // GB2
