/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include <QtGui/QApplication>
#include <QtCore/QCoreApplication>

#include <core_api/AppContext.h>
#include <core_api/Log.h>
#include <cmdline/CMDLineCoreOptions.h>

#include "CMDLineTests.h"

namespace GB2 {

#define COMMON_DATA_DIR_ENV_ID "COMMON_DATA_DIR" 
#define TEMP_DATA_DIR_ENV_ID   "TEMP_DATA_DIR" 

/************************
 * GTest_RunCMDLine
 ************************/
#ifndef _DEBUG
const QString GTest_RunCMDLine::UGENECL_PATH    = "/ugenecl";
#else
const QString GTest_RunCMDLine::UGENECL_PATH    = "/ugenecld";
#endif // _DEBUG

const QString GTest_RunCMDLine::TMP_DATA_DIR_PREFIX  = "!tmp_data_dir!";
const QString GTest_RunCMDLine::COMMON_DATA_DIR_PREFIX = "!common_data_dir!";

static LogCategory log("Run CMDline");

void GTest_RunCMDLine::init(XMLTestFormat *tf, const QDomElement& el) {
    Q_UNUSED(tf);
    setUgeneclPath();
    setArgs(el);
    proc = new QProcess(this);
}

void GTest_RunCMDLine::setArgs( const QDomElement & el ) {
    QString commandLine;
    QDomNamedNodeMap map = el.attributes();
    int mapSz = map.length();
    for( int i = 0; i < mapSz; ++i ) {
        QDomNode node = map.item(i);
        if(node.nodeName() == "message"){
            expectedMessage = node.nodeValue();
            continue;
        }
        QString argument = "--" + node.nodeName() + "=" + getVal(node.nodeValue());
         if( argument.startsWith("--task") ) {
            args.prepend(argument);
            commandLine.prepend(argument + " ");
        } else {
            args.append(argument);
            commandLine.append(argument + " ");
        }
    }
    commandLine.prepend("--log-level-details ");
    log.info(commandLine);
}

QString GTest_RunCMDLine::getVal( const QString & val ) {
    if( val.isEmpty() ) {
        return val;
    }
    if( val.startsWith( COMMON_DATA_DIR_PREFIX ) ) {
        QString realVal = val.mid( COMMON_DATA_DIR_PREFIX.size() );
        QString ret = env->getVar( COMMON_DATA_DIR_ENV_ID ) + "/" + realVal;
        return ret;
    }
    if( val.startsWith( TMP_DATA_DIR_PREFIX ) ) {
        QString realVal = val.mid(TMP_DATA_DIR_PREFIX.size());
        QString ret = env->getVar( TEMP_DATA_DIR_ENV_ID ) + "/" + realVal;
        return ret;
    }
    return val;
}

void GTest_RunCMDLine::setUgeneclPath() {
    ugeneclPath = AppContext::getMainWindow() ? QApplication::applicationDirPath() : QCoreApplication::applicationDirPath();
    assert(!ugeneclPath.isEmpty());
    ugeneclPath += UGENECL_PATH;
}

void GTest_RunCMDLine::prepare() {
    proc->start( ugeneclPath, args );
}

Task::ReportResult GTest_RunCMDLine::report() {
    if( hasErrors() || isCanceled() ) {
        return ReportResult_Finished;
    }
    assert( proc != NULL );
    if( proc->state() != QProcess::NotRunning ) {
        return ReportResult_CallMeAgain;
    }
    //QProcess::ProcessError err = proc->error();
    QString output(proc->readAllStandardOutput());
    //QByteArray outputErr = proc->readAllStandardError();

    if(!expectedMessage.isEmpty()){
        log.error(output);
        if(!output.contains(expectedMessage, Qt::CaseSensitive)){
            stateInfo.setError(QString("Expected message not found in output"));
        }
    }
    
    return ReportResult_Finished;
}

void GTest_RunCMDLine::cleanup() {
}

/************************
* GTest_RunCMDLine
************************/
QList<XMLTestFactory*> CMDLineTests::createTestFactories() {
    QList<XMLTestFactory*> res;
    res.append(GTest_RunCMDLine::createFactory());
    return res;
}

} // GB2
