/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_DBXREF_H_
#define _GB2_DBXREF_H_

#include <core_api/core_api.h>

#include <QtCore/QMap>
#include <QtCore/QObject>
#include <QtScript/QScriptValue>
#include <QtScript/QScriptEngine>
#include <QtCore/QStringList>

namespace GB2 {

class GB2_COREAPI_EXPORT DBXRefInfo {
public:
    DBXRefInfo(){};
    DBXRefInfo(const QString& _name, const QString& _url, 
               const QString& _fileUrl, const QString& _comment) 
               : name(_name), url(_url), fileUrl(_fileUrl), comment(_comment){}

    QString name;
    QString url;
    QString fileUrl;
    QString comment;

    static void setupToEngine(QScriptEngine *engine);
private:    
    static QScriptValue toScriptValue(QScriptEngine *engine, DBXRefInfo const &in);
    static void fromScriptValue(const QScriptValue &object, DBXRefInfo &out);
};


class GB2_COREAPI_EXPORT DBXRefRegistry : public QObject {
    Q_OBJECT
public:
    DBXRefRegistry(QObject* p = NULL);
	
    Q_INVOKABLE DBXRefInfo getRefByKey(const QString& dbxrefKey)const {return refsByKey.value(dbxrefKey);}

    static void setupToEngine(QScriptEngine *engine);
    const QMap<QString,DBXRefInfo>& getEntries() { return refsByKey; }
private:
    static QScriptValue toScriptValue(QScriptEngine *engine, DBXRefRegistry* const &in);
    static void fromScriptValue(const QScriptValue &object, DBXRefRegistry* &out);

	QMap<QString,DBXRefInfo> refsByKey;
};
}//namespace
Q_DECLARE_METATYPE(GB2::DBXRefRegistry*)
Q_DECLARE_METATYPE(GB2::DBXRefInfo)

#endif
