/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_DNA_ASSEMBLY_ALG_REGISTRY_H_
#define _GB2_DNA_ASSEMBLY_ALG_REGISTRY_H_

#include <QList>
#include <QString>
#include <QMutex>
#include <QObject>

#include "core_api.h"

namespace GB2 {

class DnaAssemblyToRefTaskFactory;
class DnaAssemblyGUIExtensionFactory;


class GB2_COREAPI_EXPORT DnaAssemblyAlgRegistry : public QObject {
	Q_OBJECT
public:	
	DnaAssemblyAlgRegistry(QObject* pOwn = 0);
	~DnaAssemblyAlgRegistry();
    bool registerTask(const QString& algId, DnaAssemblyToRefTaskFactory* alg);
    bool registerGUIExtension(const QString& algId, DnaAssemblyGUIExtensionFactory* factory);
    bool hadRegistered(const QString& algId) const;
    DnaAssemblyToRefTaskFactory* getTaskFactory(const QString& algId) const;
    DnaAssemblyGUIExtensionFactory* getGUIExtensionFactory(const QString& algId) const;

    QStringList getTaskNameList() const;
private:
	QMutex mutex;
	QMap<QString, DnaAssemblyToRefTaskFactory*> algMap;
    QMap<QString, DnaAssemblyGUIExtensionFactory*> guiExtMap;
    // Copy prohibition
    DnaAssemblyAlgRegistry(const DnaAssemblyAlgRegistry& m);
	DnaAssemblyAlgRegistry& operator=(const DnaAssemblyAlgRegistry& m);
};

} // namespace

#endif
