/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_COREAPI_ID_REGISTRY_H_
#define _GB2_COREAPI_ID_REGISTRY_H_

namespace GB2 {

/*************************************
 * template class for default registry
 *************************************/
template <class T> class IdRegistry {
public:
    virtual T* getById(const QString& id) {return registry.value(id);}
    virtual bool registerEntry(T* t) {
        if (registry.contains(t->getId())) {
            return false;
        } else {
            registry.insert(t->getId(), t);
            return true;
        } 
    }
    virtual T* unregisterEntry(const QString& id) {return registry.take(id);}
    virtual ~IdRegistry() { qDeleteAll(registry.values());}

    virtual QList<T*> getAllEntries() const {return registry.values();}
    virtual QList<QString> getAllIds() const {return registry.uniqueKeys();}

protected:
    QMap<QString, T*> registry;
    
}; // IdRegistry

} // GB2

#endif // _GB2_COREAPI_ID_REGISTRY_H_
