/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "Log.h"
#include "Timer.h"

namespace GB2 {


LogServer::LogServer() {
	qRegisterMetaType<LogMessage>("LogMessage");
}

LogServer* LogServer::getInstance() {
	static LogServer instance;
	return &instance;
}

LogCategory::LogCategory(const QString& name) : categoryName(name) {
	LogServer* s = LogServer::getInstance();
	s->categories.append(this);
}

LogCategory::~LogCategory() {
// TODO possible race condition at shutdown -> log service could already be destroyed
//	LogServer* s = LogServer::getInstance();
//	s->categories.removeOne(this);
    categoryName.clear();
}

void LogCategory::message(LogLevel level, const QString& msg)  {
	LogMessage m(categoryName, level, msg);
	LogServer::getInstance()->message(m);
}

LogMessage::LogMessage(const QString& cat, LogLevel l, const QString& m) 
: category(cat), level(l), text(m), time(GTimer::currentTimeMicros()) 
{
}


}//namespace
