/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_SUBST_MATRIX_REGISTRY_H_
#define _GB2_SUBST_MATRIX_REGISTRY_H_

#include <core_api/core_api.h>
#include <datatype/SMatrix.h>

#include <QtCore/QMutex>
#include <QtCore/QMap>
#include <QtCore/QStringList>

namespace GB2 {

class GB2_COREAPI_EXPORT SubstMatrixRegistry : public QObject {
	Q_OBJECT
public:
	SubstMatrixRegistry(QObject* pOwn = 0);
	
	SMatrix getMatrix(const QString& name);
	
    QList<SMatrix> getMatrices() const;

    QStringList getMatrixNames() const;

	QList<SMatrix> selectMatricesByAlphabet(DNAAlphabet* al) const;
    
    QStringList selectMatrixNamesByAlphabet(DNAAlphabet* al) const;

    void registerMatrix(const SMatrix& m);

    static SMatrix readMatrixFromFile(const QString& fileName, QString& error);
    
private:
    void readMatrices();
    static SMatrix parseMatrix(const QString& name, const QByteArray& text, QString& error);

	mutable QMutex mutex;
	QMap<QString, SMatrix> matrixByName;
};

} // namespace

#endif
