/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "SettingsImpl.h"
//#include "AppContextImpl.h"

namespace GB2 {

#ifdef _DEBUG
#define PRODUCT_NAME "UGENED"
#else
#define PRODUCT_NAME "UGENE"
#endif

#ifdef Q_WS_MAC
SettingsImpl::SettingsImpl(QSettings::Scope scope) : settings(QSettings::NativeFormat, scope, "Unipro", PRODUCT_NAME)
#else
SettingsImpl::SettingsImpl(QSettings::Scope scope) : settings(QSettings::IniFormat, scope, "Unipro", PRODUCT_NAME)
#endif
 {}

SettingsImpl::SettingsImpl(const QString & fileName) : settings(fileName, QSettings::IniFormat)
{}

bool SettingsImpl::contains(const QString& pathName) const {
    QString key = preparePath(pathName);
    return settings.contains(key);
}

void SettingsImpl::remove(const QString& pathName) {
    QString key = preparePath(pathName);
    settings.remove(key);
}


QVariant SettingsImpl::getValue(const QString& pathName, const QVariant& defaultValue) const {
    QString key = preparePath(pathName);
    return settings.value(key, defaultValue);
}

void SettingsImpl::setValue(const QString& pathName, const QVariant& value) {
    QString key = preparePath(pathName);
    settings.setValue(key, value);
}

QStringList SettingsImpl::getAllKeys(const QString& path) {
    QString key = preparePath(path);
    settings.beginGroup(key);
    QStringList allKeys = settings.allKeys();
    settings.endGroup();
    return allKeys;
}


QString SettingsImpl::preparePath(const QString& pathName) const {
    QString result = pathName.trimmed().replace("//", "/").replace("\\", "/");
    if (result.endsWith("/")) {
        result = result.left(result.length() - 1) ;
    }
    return result;
}

}//namespace
