/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "AnnotationData.h"

namespace GB2 {

QDataStream& operator>>(QDataStream& dataStream, TriState& state) {
    int st;
    dataStream >> st;
    switch (st) {
        case 0: state = TriState_Yes; break;
        case 1: state = TriState_No; break;
        default: state = TriState_Unknown;
    }
    return dataStream;
}

QDataStream& operator<<(QDataStream& dataStream, const TriState& state) {
    switch (state) {
        case TriState_Yes: return dataStream << 0;
        case TriState_No: return dataStream << 1;
        default: return dataStream << 2;
    }
}

QDataStream& operator>>(QDataStream& dataStream, Qualifier& q) {
    return dataStream >> q.name >> q.val;
}

QDataStream& operator<<(QDataStream& dataStream, const Qualifier& q) {
    return dataStream << q.name << q.val;
}

QDataStream& operator>>(QDataStream& dataStream, AnnotationData& data) {
    return dataStream >> data.complement >> data.aminoStrand >> data.name >> data.location >> data.qualifiers;
}

QDataStream& operator<<(QDataStream& dataStream, const AnnotationData& data) {
    return dataStream << data.complement << data.aminoStrand << data.name << data.location << data.qualifiers;
}

}
