/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_POSITION_WEIGHT_MATRIX_H_
#define _GB2_POSITION_WEIGHT_MATRIX_H_

#include <core_api/core_api.h>
#include <QtCore/QVarLengthArray>

namespace GB2 {
//Type of Weight matrix
enum PWMatrixType {
    PWM_MONONUCLEOTIDE,
    PWM_DINUCLEOTIDE
};

class GB2_COREAPI_EXPORT UniprobeInfo {
public:
    //default empty constructor
    UniprobeInfo();

    //constructor from parsed data
    UniprobeInfo(const QMap<QString, QString>& properties);

    //constructor from raw data
    UniprobeInfo(const QString& data);

    QString getProperty (const QString& name) const;

    QMap<QString, QString> getProperties() const;

private:
    QMap<QString, QString> properties;
};

//Position frequency matrix
//Also known as PSSM - Position score-specific matrix
class GB2_COREAPI_EXPORT PWMatrix {
public:
    //create empty matrix
    PWMatrix() : data(QVarLengthArray<float>()), length(0), type(PWM_MONONUCLEOTIDE) {};

    //create matrix from pre-counted data
    PWMatrix(const QVarLengthArray<float> &matrix, const PWMatrixType& type);

    //get internal index of position in 1-dimensional array
    int index (int row, int column) const;

    //get length of matrix row
    int getLength () const;

    //get type of matrix: mono- or dinucleotide
    PWMatrixType getType() const;

    //get value at specified position
    float getValue (int row, int column) const;

    //get sum of minimum values in each column
    float getMinSum () const;

    //get sum of maximum values in each column
    float getMaxSum () const;

    //set UniPROBE info for matrix
    void setInfo (const UniprobeInfo& info);

    //get specified UniPROBE property
    QString getProperty (const QString& propertyName) const;
    
    //get all UniPROBE properties
    QMap<QString, QString> getProperties() const;


private:
    QVarLengthArray<float> data;
    int length;
    PWMatrixType type;
    float minSum, maxSum;
    UniprobeInfo info;
    
};

}//namespace

#endif
