/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/


#include <cassert>

#include "LocalTask.h"

namespace GB2 {

LocalTask::LocalTask(const QString &name, TaskFlags flags):
    Task(name, flags)
{
}

LocalTaskFactoryRegistry::LocalTaskFactoryRegistry() {
}

void LocalTaskFactoryRegistry::registerLocalTaskFactory( LocalTaskFactory * factory ) {
    if( NULL == factory ) {
        return;
    }
    QString factoryId = factory->getId();
    assert( !factoryId.isEmpty() );
    factories.insert( factoryId, factory );
}

bool LocalTaskFactoryRegistry::unregisterLocalTaskFactory( const QString & id ) {
    assert( !id.isEmpty() );
    int howMany = factories.remove( id );
    assert( 0 == howMany || 1 == howMany );
    return 1 == howMany;
}

bool LocalTaskFactoryRegistry::isLocalTaskFactoryRegistered( const QString & id ) const {
    assert( !id.isEmpty() );
    return factories.contains( id );
}

const LocalTaskFactory * LocalTaskFactoryRegistry::getLocalTaskFactory( const QString &id ) const {
    assert( !id.isEmpty() );
    return factories.value( id, NULL );
}

QStringList LocalTaskFactoryRegistry::getLocalTaskFactoryIds() const {
    return factories.keys();
}

} // GB2
