/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/


#ifndef _GB2_REMOTE_TASK_ERROR_H
#define _GB2_REMOTE_TASK_ERROR_H

#include <QtCore/QString>

#include <core_api/core_api.h>

#include "Serializable.h"

namespace GB2 {

class GB2_COREAPI_EXPORT RemoteTaskError : public Serializable {
public:
    RemoteTaskError( bool, const QString & );
    RemoteTaskError( bool );
    RemoteTaskError();
    
    virtual QVariant serialize() const;
    virtual bool deserialize( const QVariant & data );

    bool getOk() const;
    QString getMsg() const;

private:
    bool ok;
    QString msg;

}; // RemoteTaskError

} // GB2

#endif // _GB2_REMOTE_TASK_ERROR_H
