/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "DNAChromatogramObject.h"

#include "GObjectTypes.h"

namespace GB2 {

DNAChromatogramObject::DNAChromatogramObject(const DNAChromatogram& c, const QString& objectName,const QVariantMap& hints) 
: GObject(GObjectTypes::CHROMATOGRAM, objectName, hints), chrom(c)
{

}

GObject* DNAChromatogramObject::clone() const {
    DNAChromatogramObject* cln = new DNAChromatogramObject(chrom, getGObjectName(), getGHintsMap());
    cln->setIndexInfo(getIndexInfo());
    return cln;
}

}//namespace


