/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_MALIGNMENT_OBJECT_H_
#define _GB2_MALIGNMENT_OBJECT_H_

#include <core_api/GObject.h>
#include <core_api/LRegion.h>
#include <datatype/MAlignment.h>

#include "GObjectTypes.h"

namespace GB2 {

class GHints;
class DNASequence;

class MAlignmentModInfo {
public:
    MAlignmentModInfo() : sequenceContentChanged(true), sequenceListChanged(true) {}
    bool sequenceContentChanged;
    bool sequenceListChanged;
};

class GB2_COREAPI_EXPORT MAlignmentObject : public GObject {
    Q_OBJECT
public:

    explicit MAlignmentObject(const MAlignment& a, const QVariantMap& hintsMap = QVariantMap())
        : GObject(GObjectTypes::MULTIPLE_ALIGNMENT, a.getName(), hintsMap), msa(a){};

    const MAlignment& getMAlignment() const {return msa;}
	
	char charAt(int seqNum, int pos) const {return msa.charAt(seqNum, pos);}

    virtual GObject* clone() const;

    void insertGap(int seqNum, int pos, int nGaps);
    
    void insertGap(int pos, int nGaps);

    int deleteGap(int seqNum, int pos, int maxGaps);
    
    int deleteGap(int pos, int maxGaps);

	void addRow(const DNASequence& seq, int seqIdx = -1);

    void removeRow(int seqNum);

    void renameRow(int seqNum, const QString& newName);

    void removeRegion(int startPos, int startRow, int nBases, int nRows, bool removeEmptyRows);

    void crop(LRegion window, const QSet<QString>& rowNames);

    void setMAlignment(const MAlignment& ma);

    DNAAlphabet* getAlphabet() const { return msa.getAlphabet(); }

    virtual void setGObjectName(const QString& newName);

	int getLength() const {return msa.getLength();}

signals:
    void si_alignmentChanged(const MAlignment& maBefore, const MAlignmentModInfo& modInfo);
    
protected:
    MAlignment msa;
};


}//namespace


#endif
