/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_REMOVE_PART_FROM_SEQUENCE_TASK_TESTS_H_
#define _GB2_REMOVE_PART_FROM_SEQUENCE_TASK_TESTS_H_

#include <core_api/core_api.h>
#include <core_api/LRegion.h>
#include <core_api/GObject.h>

#include <gobjects/DNASequenceObject.h>

#include <test_framework/xmltest/XMLTestUtils.h>

#include <QtXml/QDomElement>

#include <util_tasks/RemovePartFromSequenceTask.h>

namespace GB2 {

class GTest_RemovePartFromSequenceTask : GTest {
Q_OBJECT
public:
    SIMPLE_XML_TEST_BODY_WITH_FACTORY_EXT(GTest_RemovePartFromSequenceTask, "Remove_Part_From_Sequence_Task", TaskFlags_NR_FOSCOE);

    ~GTest_RemovePartFromSequenceTask();

    void prepare();
    void cleanup();
    Task::ReportResult report();
private:
    RemovePartFromSequenceTask::AnnotationStrategyForRemove strat;
    QString             docName;
    QString             seqName;
    int                 startPos;
    int                 length;
    QString             annotationName;
    QString             expectedSequence;
    QList<LRegion>      expectedRegions;
    DNASequenceObject*  dnaso;
};

class RemovePartFromSequenceTests {
public:
    static QList< XMLTestFactory* > createTestFactories();

};
}//ns
#endif
