/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_DNA_ASSEMBLEY_DIALOG_H_
#define _GB2_DNA_ASSEMBLEY_DIALOG_H_

#include <QtCore/QVariant>

#include <core_api/GUrl.h>
#include <ui/ui_AssemblyToRefDialog.h>

namespace GB2 {

class DnaAssemblyAlgRegistry;
class DnaAssemblyGUIExtensionWidget;

class DnaAssemblyDialog : public QDialog, private Ui::AssemblyToRefDialog    {
    Q_OBJECT

public:
    DnaAssemblyDialog(const DnaAssemblyAlgRegistry* registry, QWidget* p = NULL);
    const GUrl getRefSeqUrl();
    const QList<GUrl> getShortReadUrls();
    const QString getAlgorithmName();
    const QString getResultFileName();
    QMap<QString,QVariant> getCustomSettings();

protected:
    bool eventFilter(QObject *, QEvent *);

private slots:
    void sl_onAddRefButtonClicked();
    void sl_onAddShortReadsButtonClicked();
    void sl_onRemoveShortReadsButtonClicked();
    void sl_onSetResultFileNameButtonClicked();
	void sl_onAlgorithmChanged(const QString &text);

private:
    const DnaAssemblyAlgRegistry* assemblyRegistry;
    DnaAssemblyGUIExtensionWidget* customGUI;
    static QString genomePath;
    static QList<QString> shortReads;
    void updateState();
    void addGuiExtension();
    void buildResultUrl(const GUrl& url);
    void accept();


};

} // namespace

#endif //  _GB2_DNA_ASSEMBLEY_DIALOG_H_