/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include <gobjects/MAlignmentObject.h>

#include "DnaAssemblyTask.h"
#include "DnaAssemblyTests.h"
#include "DnaAssemblyUtils.h"

namespace GB2 {

#define REF_SEQ_ATTR "ref-seq"
#define METHOD_NAME_ATTR "assembly-method"
#define SHORT_READS_ATTR "shortreads"
#define RES_OBJ_NAME "res-index"

void GTest_DnaAssemblyToReferenceTask::init(XMLTestFormat *tf, const QDomElement& el) 
{
    Q_UNUSED(tf);

    refSeqUrl = el.attribute(REF_SEQ_ATTR);
    if (refSeqUrl.isEmpty()) {
        failMissingValue(REF_SEQ_ATTR);
        return;
    }
    refSeqUrl.prepend(env->getVar("COMMON_DATA_DIR") + "/");

    algName = el.attribute(METHOD_NAME_ATTR);
    if (algName.isEmpty()) {
        failMissingValue(METHOD_NAME_ATTR);
        return;
    }

    QString shortReads = el.attribute(SHORT_READS_ATTR);
    if (shortReads.isEmpty()) {
        failMissingValue(SHORT_READS_ATTR);
        return;
    }
    
    objName = el.attribute(RES_OBJ_NAME);
    if (objName.isEmpty()) {
        failMissingValue(RES_OBJ_NAME);
        return;
    }

    QStringList shortReadList = shortReads.split(";");
    if (shortReadList.isEmpty()) {
        setError("No short reads urls are found in test");
        return;
    }

    foreach (const QString& url, shortReadList) {
        shortReadUrls.append(GUrl(env->getVar("COMMON_DATA_DIR") + "/" + url));
    }

}

void GTest_DnaAssemblyToReferenceTask::prepare()
{
    expectedObj = getContext<MAlignmentObject>(this, objName);
    if(expectedObj == NULL){
        stateInfo.setError(  QString("Error can't cast to malignment object from GObject %1").arg(objName) );
        return;
    }
    
    DnaAssemblyToRefTaskSettings settings;
    settings.algName = algName;
    settings.refSeqUrl = refSeqUrl;
    
    assemblyMultiTask = new DnaAssemblyMultiTask( settings, shortReadUrls, false);

    addSubTask(assemblyMultiTask);
}

Task::ReportResult GTest_DnaAssemblyToReferenceTask::report()
{
    if (hasErrors() || isCanceled()) {
        return ReportResult_Finished;
    }
    
    const MAlignment aln = assemblyMultiTask->getAssemblyResult();
    
    if (aln != expectedObj->getMAlignment()) {
        setError("Expected and result alignments don't match");
    }


    return ReportResult_Finished;
}

///////////////////////////////////////////////////////////////////////////////////////////

QList<XMLTestFactory*> DnaAssemblyTests::createTestFactories()
{
    QList<XMLTestFactory*> res;
    res.append(GTest_DnaAssemblyToReferenceTask::createFactory());
    
    return res;
}

} // GB2
