/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_DIALOG_UTILS_H_
#define _GB2_DIALOG_UTILS_H_

#include <core_api/core_api.h>

#include <QtCore/QObject>
#include <QtGui/QWidget>

namespace GB2 {

class DocumentFormatConstraints;
class LogCategory;
class TaskStateInfo;


class GB2_COREAPI_EXPORT DialogUtils : public QObject {
	Q_OBJECT
public:
	static void showProjectIsLockedWarning(QWidget* p = NULL);

    static QString prepareFileFilter(const QString& name, const QStringList& exts, bool any = true, const QStringList& extraExts = QStringList(".gz"));

    static QString prepareDocumentsFileFilter(const DocumentFormatId& fid, bool any, const QStringList& extraExts = QStringList(".gz"));

    //returns filter for all formats supported. All-docs filter is returned first if any==true
    static QString prepareDocumentsFileFilter(bool any, const QStringList& extraExts = QStringList(".gz"));

    static QString prepareDocumentsFileFilter(const DocumentFormatConstraints& c, bool any);

    static QString prepareDocumentsFileFilterByObjType(const GObjectType& t, bool any);


    static QString getLastOpenFileDir(const QString& toolType = QString(), const QString& defaultVal = QString());

    static void setLastOpenFileDir(const QString& ld, const QString& toolType = QString());

};

class GB2_COREAPI_EXPORT LastOpenDirHelper {
public:
    LastOpenDirHelper(const QString& domain = QString(), const QString& defaultVal = QString()); //reads dir
    virtual ~LastOpenDirHelper(); //if url is not empty -> derives dir from url and stores it
    
    operator const QString&() const {return dir;} 
    void saveURLDir2LastOpenDir();

    QString domain;

    //last used dir
    QString dir;

    // value returned by file dialog
    QString url;
};
} // namespace

#endif
