/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/


#include <QtGui/QLabel>
#include <QtGui/QMessageBox>

#include <core_api/AppContext.h>
#include <distributed_computing/ProtocolUI.h>

#include "RemoteMachineModifyDialogImpl.h"

namespace GB2 {

RemoteMachineModifyDialogImpl::RemoteMachineModifyDialogImpl( RemoteMachineSettings * machine ) : newMachine( NULL ) {
    setupUi( this );
    connect( cancelPushButton, SIGNAL( clicked() ), SLOT( reject() ) );
    connect( okPushButton, SIGNAL( clicked() ), SLOT( sl_okPushButtonClicked() ) );
    
    if( NULL == machine ) {
        showErrorLabel( tr( "Internal error: given machine is null" ) );
        return;
    }
    ProtocolInfo * protoInfo = AppContext::getProtocolInfoRegistry()->getProtocolInfo( machine->getProtocolId() );
    assert( NULL != protoInfo );
    protoUi = protoInfo->getProtocolUI();
    if( NULL == protoUi ) {
        showErrorLabel( tr( "No protocol widget found for selected machine" ) );
        return;
    }
    
    protoUi->initializeWidget( machine );
    QVBoxLayout * topLayout = qobject_cast< QVBoxLayout* >( layout() );
    assert( NULL != topLayout );
    topLayout->insertWidget( 0, protoUi );
}

RemoteMachineModifyDialogImpl::~RemoteMachineModifyDialogImpl() {
    delete newMachine;

    if( NULL != protoUi ) {
        protoUi->setParent( NULL );
    }
}

void RemoteMachineModifyDialogImpl::showErrorLabel( const QString & msg ) {
    assert( !msg.isEmpty() );
    QLabel * errorLable = new QLabel( msg, this );
    QVBoxLayout * topLayout = qobject_cast< QVBoxLayout* >( layout() );
    assert( NULL != topLayout );
    topLayout->insertWidget( 0, errorLable );
}

RemoteMachineSettings * RemoteMachineModifyDialogImpl::getNewModifiedMachine() const {
    return newMachine;
}

RemoteMachineSettings * RemoteMachineModifyDialogImpl::takeNewModifiedMachine() {
    RemoteMachineSettings * ret = newMachine;
    newMachine = NULL;
    return ret;
}

void RemoteMachineModifyDialogImpl::sl_okPushButtonClicked() {
    if( NULL == protoUi ) {
        QDialog::accept();
        return;
    }
    QString error = protoUi->validate();
    if( !error.isEmpty() ) {
        QMessageBox::critical( this, tr( "Error!" ), error );
        return;
    }
    
    newMachine = protoUi->createMachine();
    if( NULL == newMachine ) {
        QMessageBox::critical( this, tr( "Error!" ), tr( "Sorry! Cannot create remote machine" ) );
        return;
    }
    QDialog::accept();
}

} // GB2
