/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include"SeqPasterWidgetController.h"

#include <core_api/AppContext.h>
#include <core_api/DNAAlphabet.h>

#include <core_api/Log.h>

#include <qchar.h>


namespace GB2{

static LogCategory log(ULOG_CAT_USER_INTERFACE);

SeqPasterWidgetController::SeqPasterWidgetController(QObject *p): QObject(p), preferred(0) {
    //TODO:add not null project checking
    w = new QWidget();
    setupUi(w);

    QList<DNAAlphabet*> alps = AppContext::getDNAAlphabetRegistry()->getRegisteredAlphabets();
    foreach(DNAAlphabet *a, alps){
        alphabetBox->addItem(a->getName(), a->getId());
    }
    connect(alphabetBox, SIGNAL(currentIndexChanged(const QString&)), SLOT(sl_currentindexChanged(const QString&)));
}


QString SeqPasterWidgetController::validate(){
    if(sequenceEdit->toPlainText().isEmpty()){
        return tr("Input sequence is empty");
    }
    QByteArray seq = ((sequenceEdit->document())->toPlainText()).toUtf8(), normSequence;
    DNAAlphabetRegistry *r = AppContext::getDNAAlphabetRegistry();
    DNAAlphabet *alph = NULL;
    if(useCustomSettingsBox->isChecked()){
        alph = r->findById((alphabetBox->itemData(alphabetBox->currentIndex())).toString());
    }else{
        if(preferred != NULL){
            alph = preferred;
        }else{
            alph = r->findAlphabet(seq);
        }
    }
    if(alph == NULL){
        return tr("Alphabet not detected");
    }

    if(alph->getId() == BaseDNAAlphabetIds::RAW){
        foreach(QChar c, seq){
            QChar::Category cat = c.category();
            if((cat != QChar::Separator_Space) &&
               (cat != QChar::Other_Control)){
                   normSequence.append(c);
            }
        }
    }else{
        QByteArray alphabetSymbols = alph->getAlphabetChars(true);
        for(int i = 0; i < seq.size(); i++){
            QChar c = seq.at(i);
            if(alphabetSymbols.indexOf(c) > -1){
                normSequence.append(c);
            }else{
                if (replaceRB->isChecked()){
                    c = symbolToReplaceEdit->text().at(0);
                    normSequence.append(c);
                }
            }
        }
    }
       
    resultSeq = DNASequence("sequence", normSequence, alph);

    return QString();
}

void SeqPasterWidgetController::sl_currentindexChanged( const QString& newText){
    DNAAlphabetRegistry *r = AppContext::getDNAAlphabetRegistry();
    if((r->findById(BaseDNAAlphabetIds::RAW))->getName() == newText){
        skipRB->setDisabled(true);
        replaceRB->setDisabled(true);
        symbolToReplaceEdit->setDisabled(true);
    }else{
        skipRB->setEnabled(true);
        replaceRB->setEnabled(true);
        symbolToReplaceEdit->setEnabled(true);
    }
}

void SeqPasterWidgetController::disableCustomSettings(){
    useCustomSettingsBox->setChecked(false);
    useCustomSettingsBox->setDisabled(true);
	useCustomSettingsBox->hide();
	groupBox->hide();
}

void SeqPasterWidgetController::setPreferredAlphabet( DNAAlphabet *alp ){
    preferred = alp;
}

}//ns
