/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "AnnotatedDNAViewState.h"
#include "AnnotatedDNAView.h"
#include "AnnotatedDNAViewFactory.h"
#include "ADVSequenceObjectContext.h"

#include <gobjects/AnnotationTableObject.h>
#include <gobjects/DNASequenceObject.h>
#include <gobjects/GObjectTypes.h>

#include <selection/DNASequenceSelection.h>
#include <core_api/DocumentModel.h>
#include <core_api/DNATranslation.h>

namespace GB2 {


#define VIEW_ID					QString("view_id")
#define SEQUENCE_OBJECTS        QString("dna_obj_ref")
#define ANNOTATION_OBJECTS      QString("ann_obj_ref")
#define SEQUENCE_SELECTION      QString("dna_obj_sel")


AnnotatedDNAViewState::AnnotatedDNAViewState() {
}

bool AnnotatedDNAViewState::isValid() const {
	bool idOK = stateData.value(VIEW_ID) == AnnotatedDNAViewFactory::ID;
    return idOK && !getSequenceObjects().isEmpty();
}

QList<GObjectReference> AnnotatedDNAViewState::getSequenceObjects() const {
    QList<GObjectReference> res = stateData.value(SEQUENCE_OBJECTS).value<QList<GObjectReference> >();
    return res;
}

void AnnotatedDNAViewState::setSequenceObjects(const QList<GObjectReference>& objs, const QList<LRegion>& selections) {
    assert(objs.size() == selections.size());
	stateData[SEQUENCE_OBJECTS] = QVariant::fromValue<QList<GObjectReference> >(objs);
    stateData[SEQUENCE_SELECTION]= QVariant::fromValue<QList<LRegion> >(selections);
}


QList<LRegion> AnnotatedDNAViewState::getSequenceSelections() const {
    QList<LRegion> res = stateData.value(SEQUENCE_SELECTION).value<QList<LRegion> >();
    return res;
}

QList<GObjectReference> AnnotatedDNAViewState::getAnnotationObjects() const {
    QList<GObjectReference> res = stateData.value(ANNOTATION_OBJECTS).value<QList<GObjectReference> >();
    return res;
}

void AnnotatedDNAViewState::setAnnotationObjects(const QList<GObjectReference>& objs) {
    stateData[ANNOTATION_OBJECTS] = QVariant::fromValue<QList<GObjectReference> >(objs);
}

QVariantMap AnnotatedDNAViewState::saveState(AnnotatedDNAView* v) {
    AnnotatedDNAViewState s;
    s.stateData[VIEW_ID] = AnnotatedDNAViewFactory::ID;
    QList<GObjectReference> seqRefs;
    QList<LRegion> seqSels;
    foreach(const ADVSequenceObjectContext * ctx, v->getSequenceContexts()) {
        seqRefs.append(ctx->getSequenceObject());
        DNASequenceSelection* sel = ctx->getSequenceSelection();
        seqSels.append(sel->isEmpty()? LRegion() : sel->getSelectedRegions().first());
    }
    
    QList<GObjectReference> anRefs;
    foreach(GObject* ao, v->getAnnotationObjects()) {
        anRefs.append(ao);
    }
    s.setSequenceObjects(seqRefs, seqSels);
    s.setAnnotationObjects(anRefs);

    return s.stateData;
}


} // namespace

