/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "CreateRulerDialogController.h"

#include <util_text/TextUtils.h>

#include <QtGui/QSpinBox>
#include <QtGui/QLabel>
#include <QtGui/QPalette>
#include <QtGui/QLineEdit>
#include <QtGui/QMessageBox>
#include <QtGui/QColorDialog>

namespace GB2 {

CreateRulerDialogController::CreateRulerDialogController(const QSet<QString>& namesToFilter, const LRegion& range, int _offset, QWidget* p) 
: QDialog(p)
{
    setupUi(this);
    filter = namesToFilter;

    sampleLabel->setAutoFillBackground(true);
   
    nameEdit->setText(TextUtils::variate(tr("New ruler"), "_", filter));

    spinBox->setMinimum(range.startPos + 1);
    spinBox->setMaximum(range.endPos());
    spinBox->setValue(range.contains(_offset+1) ? _offset + 1 : spinBox->minimum());

    color = Qt::darkBlue;
    
    updateColorSample();

    connect(colorButton, SIGNAL(clicked()), SLOT(sl_colorButtonClicked()));
}

void CreateRulerDialogController::updateColorSample() {
    QPalette lPal;
    lPal.setColor(QPalette::Window, Qt::white);
    lPal.setColor(QPalette::WindowText, color);
    sampleLabel->setPalette(lPal);
}

void CreateRulerDialogController::sl_colorButtonClicked() {
    QColor c = QColorDialog::getColor(color, this);
    if (!c.isValid()) {
        return;
    }
    color = c;
    updateColorSample();
}

void CreateRulerDialogController::accept() {
    QString n = nameEdit->text();
    if (n.isEmpty()) {
        QMessageBox::critical(NULL, tr("Error"), tr("Ruler name is empty!"));
        nameEdit->setFocus();
        return;
    }
    if (filter.contains(n)) {
        QMessageBox::critical(NULL, tr("Error"), tr("Ruler with the same name is already exists!"));
        nameEdit->setFocus();
        return;
    }
    name = n;
    offset = spinBox->value() - 1;
    QDialog::accept();
}

}//namespace


