/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_ADD_SEQUENCES_TO_ALIGNMENT_TASK_H_
#define _GB2_ADD_SEQUENCES_TO_ALIGNMENT_TASK_H_

#include <core_api/Task.h>
#include <gobjects/MAlignmentObject.h>

#include <QtCore/QPointer>


namespace GB2 {

class LoadDocumentTask;

class AddSequencesToAlignmentTask : public Task {
    Q_OBJECT
public:
    AddSequencesToAlignmentTask(MAlignmentObject* obj, const QString& fileWithSequences);

    QList<Task*> onSubTaskFinished(Task* subTask);

    ReportResult report();

    QPointer<MAlignmentObject>  maObj;
    LoadDocumentTask*           loadTask;
};

}// namespace

#endif //_GB2_ADD_SEQUENCES_TO_ALIGNMENT_TASK_H_
